/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;

public abstract class InstanceKeyDataSource
implements DataSource,
Referenceable,
Serializable,
AutoCloseable {
    private static final long serialVersionUID = -6819270431752240878L;
    private static final String GET_CONNECTION_CALLED = "A Connection was already requested from this source, further initialization is not allowed.";
    private static final String BAD_TRANSACTION_ISOLATION = "The requested TransactionIsolation level is invalid.";
    protected static final int UNKNOWN_TRANSACTIONISOLATION = -1;
    private volatile boolean getConnectionCalled;
    private ConnectionPoolDataSource dataSource;
    private String dataSourceName;
    private String description;
    private Properties jndiEnvironment;
    private int loginTimeout;
    private PrintWriter logWriter;
    private String instanceKey;
    private boolean defaultBlockWhenExhausted = true;
    private String defaultEvictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean defaultLifo = true;
    private int defaultMaxIdle = 8;
    private int defaultMaxTotal = -1;
    private long defaultMaxWaitMillis = -1L;
    private long defaultMinEvictableIdleTimeMillis = 1800000L;
    private int defaultMinIdle = 0;
    private int defaultNumTestsPerEvictionRun = 3;
    private long defaultSoftMinEvictableIdleTimeMillis = -1L;
    private boolean defaultTestOnCreate = false;
    private boolean defaultTestOnBorrow = false;
    private boolean defaultTestOnReturn = false;
    private boolean defaultTestWhileIdle = false;
    private long defaultTimeBetweenEvictionRunsMillis = -1L;
    private String validationQuery;
    private int validationQueryTimeoutSeconds = -1;
    private boolean rollbackAfterValidation;
    private long maxConnLifetimeMillis = -1L;
    private Boolean defaultAutoCommit;
    private int defaultTransactionIsolation = -1;
    private Boolean defaultReadOnly;

    protected void assertInitializationAllowed() throws IllegalStateException {
        if (this.getConnectionCalled) {
            throw new IllegalStateException(GET_CONNECTION_CALLED);
        }
    }

    @Override
    public abstract void close() throws Exception;

    protected abstract PooledConnectionManager getConnectionManager(UserPassKey var1);

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("InstanceKeyDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public boolean getDefaultBlockWhenExhausted() {
        return this.defaultBlockWhenExhausted;
    }

    public void setDefaultBlockWhenExhausted(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultBlockWhenExhausted = bl;
    }

    public String getDefaultEvictionPolicyClassName() {
        return this.defaultEvictionPolicyClassName;
    }

    public void setDefaultEvictionPolicyClassName(String string) {
        this.assertInitializationAllowed();
        this.defaultEvictionPolicyClassName = string;
    }

    public boolean getDefaultLifo() {
        return this.defaultLifo;
    }

    public void setDefaultLifo(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultLifo = bl;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = n;
    }

    public int getDefaultMaxTotal() {
        return this.defaultMaxTotal;
    }

    public void setDefaultMaxTotal(int n) {
        this.assertInitializationAllowed();
        this.defaultMaxTotal = n;
    }

    public long getDefaultMaxWaitMillis() {
        return this.defaultMaxWaitMillis;
    }

    public void setDefaultMaxWaitMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultMaxWaitMillis = l;
    }

    public long getDefaultMinEvictableIdleTimeMillis() {
        return this.defaultMinEvictableIdleTimeMillis;
    }

    public void setDefaultMinEvictableIdleTimeMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultMinEvictableIdleTimeMillis = l;
    }

    public int getDefaultMinIdle() {
        return this.defaultMinIdle;
    }

    public void setDefaultMinIdle(int n) {
        this.assertInitializationAllowed();
        this.defaultMinIdle = n;
    }

    public int getDefaultNumTestsPerEvictionRun() {
        return this.defaultNumTestsPerEvictionRun;
    }

    public void setDefaultNumTestsPerEvictionRun(int n) {
        this.assertInitializationAllowed();
        this.defaultNumTestsPerEvictionRun = n;
    }

    public long getDefaultSoftMinEvictableIdleTimeMillis() {
        return this.defaultSoftMinEvictableIdleTimeMillis;
    }

    public void setDefaultSoftMinEvictableIdleTimeMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultSoftMinEvictableIdleTimeMillis = l;
    }

    public boolean getDefaultTestOnCreate() {
        return this.defaultTestOnCreate;
    }

    public void setDefaultTestOnCreate(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnCreate = bl;
    }

    public boolean getDefaultTestOnBorrow() {
        return this.defaultTestOnBorrow;
    }

    public void setDefaultTestOnBorrow(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnBorrow = bl;
    }

    public boolean getDefaultTestOnReturn() {
        return this.defaultTestOnReturn;
    }

    public void setDefaultTestOnReturn(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestOnReturn = bl;
    }

    public boolean getDefaultTestWhileIdle() {
        return this.defaultTestWhileIdle;
    }

    public void setDefaultTestWhileIdle(boolean bl) {
        this.assertInitializationAllowed();
        this.defaultTestWhileIdle = bl;
    }

    public long getDefaultTimeBetweenEvictionRunsMillis() {
        return this.defaultTimeBetweenEvictionRunsMillis;
    }

    public void setDefaultTimeBetweenEvictionRunsMillis(long l) {
        this.assertInitializationAllowed();
        this.defaultTimeBetweenEvictionRunsMillis = l;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.dataSource;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.assertInitializationAllowed();
        if (this.dataSourceName != null) {
            throw new IllegalStateException("Cannot set the DataSource, if JNDI is used.");
        }
        if (this.dataSource != null) {
            throw new IllegalStateException("The CPDS has already been set. It cannot be altered.");
        }
        this.dataSource = connectionPoolDataSource;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.assertInitializationAllowed();
        if (this.dataSource != null) {
            throw new IllegalStateException("Cannot set the JNDI name for the DataSource, if already set using setConnectionPoolDataSource.");
        }
        if (this.dataSourceName != null) {
            throw new IllegalStateException("The DataSourceName has already been set. It cannot be altered.");
        }
        this.dataSourceName = string;
        this.instanceKey = InstanceKeyDataSourceFactory.registerNewInstance(this);
    }

    public Boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.assertInitializationAllowed();
        this.defaultAutoCommit = bl;
    }

    public Boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.assertInitializationAllowed();
        this.defaultReadOnly = bl;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.assertInitializationAllowed();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException(BAD_TRANSACTION_ISOLATION);
            }
        }
        this.defaultTransactionIsolation = n;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    protected String getInstanceKey() {
        return this.instanceKey;
    }

    public String getJndiEnvironment(String string) {
        String string2 = null;
        if (this.jndiEnvironment != null) {
            string2 = this.jndiEnvironment.getProperty(string);
        }
        return string2;
    }

    public void setJndiEnvironment(String string, String string2) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(string, string2);
    }

    void setJndiEnvironment(Properties properties) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        } else {
            this.jndiEnvironment.clear();
        }
        this.jndiEnvironment.putAll((Map<?, ?>)properties);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) {
        this.loginTimeout = n;
    }

    @Override
    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
        }
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.assertInitializationAllowed();
        this.validationQuery = string;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeoutSeconds;
    }

    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeoutSeconds = n;
    }

    public boolean isRollbackAfterValidation() {
        return this.rollbackAfterValidation;
    }

    public void setRollbackAfterValidation(boolean bl) {
        this.assertInitializationAllowed();
        this.rollbackAfterValidation = bl;
    }

    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnLifetimeMillis = l;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Object object;
        if (this.instanceKey == null) {
            throw new SQLException("Must set the ConnectionPoolDataSource through setDataSourceName or setConnectionPoolDataSource before calling getConnection.");
        }
        this.getConnectionCalled = true;
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        try {
            pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
        }
        catch (RuntimeException | SQLException exception) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw exception;
        }
        catch (Exception exception) {
            this.closeDueToException(pooledConnectionAndInfo);
            throw new SQLException("Cannot borrow connection from pool", exception);
        }
        if (!(null != string2 ? string2.equals(pooledConnectionAndInfo.getPassword()) : null == pooledConnectionAndInfo.getPassword())) {
            try {
                this.testCPDS(string, string2);
            }
            catch (SQLException sQLException) {
                this.closeDueToException(pooledConnectionAndInfo);
                throw new SQLException("Given password did not match password used to create the PooledConnection.", sQLException);
            }
            catch (NamingException namingException) {
                throw new SQLException("NamingException encountered connecting to database", namingException);
            }
            object = pooledConnectionAndInfo.getUserPassKey();
            PooledConnectionManager pooledConnectionManager = this.getConnectionManager((UserPassKey)object);
            pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
            pooledConnectionManager.setPassword(((UserPassKey)object).getPassword());
            pooledConnectionAndInfo = null;
            for (int i = 0; i < 10; ++i) {
                try {
                    pooledConnectionAndInfo = this.getPooledConnectionAndInfo(string, string2);
                }
                catch (RuntimeException | SQLException exception) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw exception;
                }
                catch (Exception exception) {
                    this.closeDueToException(pooledConnectionAndInfo);
                    throw new SQLException("Cannot borrow connection from pool", exception);
                }
                if (pooledConnectionAndInfo != null && string2 != null && string2.equals(pooledConnectionAndInfo.getPassword())) break;
                if (pooledConnectionAndInfo != null) {
                    pooledConnectionManager.invalidate(pooledConnectionAndInfo.getPooledConnection());
                }
                pooledConnectionAndInfo = null;
            }
            if (pooledConnectionAndInfo == null) {
                throw new SQLException("Cannot borrow connection from pool - password change failure.");
            }
        }
        object = pooledConnectionAndInfo.getPooledConnection().getConnection();
        try {
            this.setupDefaults((Connection)object, string);
            object.clearWarnings();
            return object;
        }
        catch (SQLException sQLException) {
            try {
                object.close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("ignoring exception during close: " + exception);
            }
            throw sQLException;
        }
    }

    protected abstract PooledConnectionAndInfo getPooledConnectionAndInfo(String var1, String var2) throws SQLException;

    protected abstract void setupDefaults(Connection var1, String var2) throws SQLException;

    private void closeDueToException(PooledConnectionAndInfo pooledConnectionAndInfo) {
        if (pooledConnectionAndInfo != null) {
            try {
                pooledConnectionAndInfo.getPooledConnection().getConnection().close();
            }
            catch (Exception exception) {
                this.getLogWriter().println("[ERROR] Could not return connection to pool during exception handling. " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionPoolDataSource testCPDS(String string, String string2) throws NamingException, SQLException {
        Object object;
        ConnectionPoolDataSource connectionPoolDataSource = this.dataSource;
        if (connectionPoolDataSource == null) {
            object = null;
            object = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
            Object object2 = object.lookup(this.dataSourceName);
            if (object2 instanceof ConnectionPoolDataSource) {
                connectionPoolDataSource = (ConnectionPoolDataSource)object2;
            } else {
                throw new SQLException("Illegal configuration: DataSource " + this.dataSourceName + " (" + object2.getClass().getName() + ") doesn't implement javax.sql.ConnectionPoolDataSource");
            }
        }
        object = null;
        try {
            object = string != null ? connectionPoolDataSource.getPooledConnection(string, string2) : connectionPoolDataSource.getPooledConnection();
            if (object == null) {
                throw new SQLException("Cannot connect using the supplied userName/password");
            }
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return connectionPoolDataSource;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append('[');
        this.toStringFields(stringBuilder);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected void toStringFields(StringBuilder stringBuilder) {
        stringBuilder.append("getConnectionCalled=");
        stringBuilder.append(this.getConnectionCalled);
        stringBuilder.append(", dataSource=");
        stringBuilder.append(this.dataSource);
        stringBuilder.append(", dataSourceName=");
        stringBuilder.append(this.dataSourceName);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        stringBuilder.append(", jndiEnvironment=");
        stringBuilder.append(this.jndiEnvironment);
        stringBuilder.append(", loginTimeout=");
        stringBuilder.append(this.loginTimeout);
        stringBuilder.append(", logWriter=");
        stringBuilder.append(this.logWriter);
        stringBuilder.append(", instanceKey=");
        stringBuilder.append(this.instanceKey);
        stringBuilder.append(", defaultBlockWhenExhausted=");
        stringBuilder.append(this.defaultBlockWhenExhausted);
        stringBuilder.append(", defaultEvictionPolicyClassName=");
        stringBuilder.append(this.defaultEvictionPolicyClassName);
        stringBuilder.append(", defaultLifo=");
        stringBuilder.append(this.defaultLifo);
        stringBuilder.append(", defaultMaxIdle=");
        stringBuilder.append(this.defaultMaxIdle);
        stringBuilder.append(", defaultMaxTotal=");
        stringBuilder.append(this.defaultMaxTotal);
        stringBuilder.append(", defaultMaxWaitMillis=");
        stringBuilder.append(this.defaultMaxWaitMillis);
        stringBuilder.append(", defaultMinEvictableIdleTimeMillis=");
        stringBuilder.append(this.defaultMinEvictableIdleTimeMillis);
        stringBuilder.append(", defaultMinIdle=");
        stringBuilder.append(this.defaultMinIdle);
        stringBuilder.append(", defaultNumTestsPerEvictionRun=");
        stringBuilder.append(this.defaultNumTestsPerEvictionRun);
        stringBuilder.append(", defaultSoftMinEvictableIdleTimeMillis=");
        stringBuilder.append(this.defaultSoftMinEvictableIdleTimeMillis);
        stringBuilder.append(", defaultTestOnCreate=");
        stringBuilder.append(this.defaultTestOnCreate);
        stringBuilder.append(", defaultTestOnBorrow=");
        stringBuilder.append(this.defaultTestOnBorrow);
        stringBuilder.append(", defaultTestOnReturn=");
        stringBuilder.append(this.defaultTestOnReturn);
        stringBuilder.append(", defaultTestWhileIdle=");
        stringBuilder.append(this.defaultTestWhileIdle);
        stringBuilder.append(", defaultTimeBetweenEvictionRunsMillis=");
        stringBuilder.append(this.defaultTimeBetweenEvictionRunsMillis);
        stringBuilder.append(", validationQuery=");
        stringBuilder.append(this.validationQuery);
        stringBuilder.append(", validationQueryTimeoutSeconds=");
        stringBuilder.append(this.validationQueryTimeoutSeconds);
        stringBuilder.append(", rollbackAfterValidation=");
        stringBuilder.append(this.rollbackAfterValidation);
        stringBuilder.append(", maxConnLifetimeMillis=");
        stringBuilder.append(this.maxConnLifetimeMillis);
        stringBuilder.append(", defaultAutoCommit=");
        stringBuilder.append(this.defaultAutoCommit);
        stringBuilder.append(", defaultTransactionIsolation=");
        stringBuilder.append(this.defaultTransactionIsolation);
        stringBuilder.append(", defaultReadOnly=");
        stringBuilder.append(this.defaultReadOnly);
    }
}

