/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspEngineInfo;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.jasper.Constants;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private static final boolean USE_POOL = Boolean.parseBoolean(System.getProperty("org.apache.jasper.runtime.JspFactoryImpl.USE_POOL", "true"));
    private static final int POOL_SIZE = Integer.parseInt(System.getProperty("org.apache.jasper.runtime.JspFactoryImpl.POOL_SIZE", "8"));
    private final ThreadLocal<PageContextPool> localPool = new ThreadLocal();

    public PageContext getPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedGetPageContext privilegedGetPageContext = new PrivilegedGetPageContext(this, servlet, servletRequest, servletResponse, string, bl, n, bl2);
            return AccessController.doPrivileged(privilegedGetPageContext);
        }
        return this.internalGetPageContext(servlet, servletRequest, servletResponse, string, bl, n, bl2);
    }

    public void releasePageContext(PageContext pageContext) {
        if (pageContext == null) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            PrivilegedReleasePageContext privilegedReleasePageContext = new PrivilegedReleasePageContext(this, pageContext);
            AccessController.doPrivileged(privilegedReleasePageContext);
        } else {
            this.internalReleasePageContext(pageContext);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return "2.3";
            }
        };
    }

    private PageContext internalGetPageContext(Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
        PageContextImpl pageContextImpl;
        if (USE_POOL) {
            PageContextPool pageContextPool = this.localPool.get();
            if (pageContextPool == null) {
                pageContextPool = new PageContextPool();
                this.localPool.set(pageContextPool);
            }
            if ((pageContextImpl = pageContextPool.get()) == null) {
                pageContextImpl = new PageContextImpl();
            }
        } else {
            pageContextImpl = new PageContextImpl();
        }
        try {
            pageContextImpl.initialize(servlet, servletRequest, servletResponse, string, bl, n, bl2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pageContextImpl;
    }

    private void internalReleasePageContext(PageContext pageContext) {
        pageContext.release();
        if (USE_POOL && pageContext instanceof PageContextImpl) {
            this.localPool.get().put(pageContext);
        }
    }

    public JspApplicationContext getJspApplicationContext(ServletContext servletContext) {
        if (Constants.IS_SECURITY_ENABLED) {
            return AccessController.doPrivileged(() -> JspApplicationContextImpl.getInstance(servletContext));
        }
        return JspApplicationContextImpl.getInstance(servletContext);
    }

    private static final class PageContextPool {
        private final PageContext[] pool = new PageContext[JspFactoryImpl.access$200()];
        private int current = -1;

        public void put(PageContext pageContext) {
            if (this.current < POOL_SIZE - 1) {
                ++this.current;
                this.pool[this.current] = pageContext;
            }
        }

        public PageContext get() {
            PageContext pageContext = null;
            if (this.current >= 0) {
                pageContext = this.pool[this.current];
                --this.current;
            }
            return pageContext;
        }
    }

    private static class PrivilegedReleasePageContext
    implements PrivilegedAction<Void> {
        private JspFactoryImpl factory;
        private PageContext pageContext;

        PrivilegedReleasePageContext(JspFactoryImpl jspFactoryImpl, PageContext pageContext) {
            this.factory = jspFactoryImpl;
            this.pageContext = pageContext;
        }

        @Override
        public Void run() {
            this.factory.internalReleasePageContext(this.pageContext);
            return null;
        }
    }

    private static class PrivilegedGetPageContext
    implements PrivilegedAction<PageContext> {
        private JspFactoryImpl factory;
        private Servlet servlet;
        private ServletRequest request;
        private ServletResponse response;
        private String errorPageURL;
        private boolean needsSession;
        private int bufferSize;
        private boolean autoflush;

        PrivilegedGetPageContext(JspFactoryImpl jspFactoryImpl, Servlet servlet, ServletRequest servletRequest, ServletResponse servletResponse, String string, boolean bl, int n, boolean bl2) {
            this.factory = jspFactoryImpl;
            this.servlet = servlet;
            this.request = servletRequest;
            this.response = servletResponse;
            this.errorPageURL = string;
            this.needsSession = bl;
            this.bufferSize = n;
            this.autoflush = bl2;
        }

        @Override
        public PageContext run() {
            return this.factory.internalGetPageContext(this.servlet, this.request, this.response, this.errorPageURL, this.needsSession, this.bufferSize, this.autoflush);
        }
    }
}

