/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerPopup;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.SmallButton;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.openide.util.Lookup;

abstract class TablesSelector {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.jdbc.Bundle");
    private static final String SELECT_TABLES = messages.getString("TablesSelector_SelectTables");
    private static final String FILTER_TABLES = messages.getString("TablesSelector_FilterTables");
    private static final String COLUMN_SELECTED = messages.getString("TablesSelector_ColumnSelected");
    private static final String COLUMN_TABLE = messages.getString("TablesSelector_ColumnTable");
    private static final String COLUMN_SELECTED_TOOLTIP = messages.getString("TablesSelector_ColumnSelectedToolTip");
    private static final String COLUMN_TABLE_TOOLTIP = messages.getString("TablesSelector_ColumnTableToolTip");
    private static final String ACT_SELECT_ALL = messages.getString("TablesSelector_ActSelectAll");
    private static final String ACT_UNSELECT_ALL = messages.getString("TablesSelector_ActUnselectAll");
    private final String[] tables;
    private final Collection<String> selected;

    public TablesSelector(Collection<String> collection, Collection<String> collection2) {
        this.tables = collection.toArray(new String[0]);
        this.selected = new HashSet<String>(collection2);
    }

    public void show(Component component) {
        UI uI = new UI();
        uI.show(component);
    }

    protected abstract void selectionChanged(Collection<String> var1);

    private class UI {
        private JPanel panel;
        private SmallButton selectAll;
        private SmallButton unselectAll;

        UI() {
            this.populatePopup();
        }

        void show(Component component) {
            int n = 3;
            ProfilerPopup.createRelative(component, this.panel, 2, n).show();
        }

        private void populatePopup() {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel(SELECT_TABLES, 10);
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            jPanel.add((Component)jLabel, "North");
            final SelectedTablesModel selectedTablesModel = new SelectedTablesModel();
            final ProfilerTable profilerTable = new ProfilerTable(selectedTablesModel, true, false, null);
            profilerTable.setColumnToolTips(new String[]{COLUMN_SELECTED_TOOLTIP, COLUMN_TABLE_TOOLTIP});
            profilerTable.setMainColumn(1);
            profilerTable.setFitWidthColumn(1);
            profilerTable.setDefaultSortOrder(1, SortOrder.ASCENDING);
            profilerTable.setSortColumn(1);
            profilerTable.setFixedColumnSelection(0);
            profilerTable.setColumnRenderer(0, new CheckBoxRenderer());
            LabelRenderer labelRenderer = new LabelRenderer();
            profilerTable.setColumnRenderer(1, labelRenderer);
            int n = new JLabel((String)profilerTable.getColumnName((int)0)).getPreferredSize().width;
            profilerTable.setDefaultColumnWidth(0, n + 15);
            int n2 = profilerTable.getRowHeight() * 8;
            labelRenderer.setText("A LONGEST EXPECTED TABLE NAME A LONGEST EXPECTED TABLE NAME");
            Dimension dimension = new Dimension(n + labelRenderer.getPreferredSize().width, n2 += profilerTable.getTableHeader().getPreferredSize().height);
            profilerTable.setPreferredScrollableViewportSize(dimension);
            ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(profilerTable, true, null);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
            jPanel2.add((Component)profilerTableContainer, "Center");
            jPanel.add((Component)jPanel2, "Center");
            FilteringToolbar filteringToolbar = new FilteringToolbar(FILTER_TABLES){

                @Override
                protected void filterChanged() {
                    if (this.isAll()) {
                        profilerTable.setRowFilter(null);
                    } else {
                        profilerTable.setRowFilter(new RowFilter(){

                            public boolean include(RowFilter.Entry entry) {
                                return this.passes(entry.getStringValue(1));
                            }
                        });
                    }
                }
            };
            filteringToolbar.add(Box.createHorizontalStrut(2));
            ((JToolBar)filteringToolbar).addSeparator();
            filteringToolbar.add(Box.createHorizontalStrut(3));
            this.selectAll = new SmallButton(" " + ACT_SELECT_ALL + " "){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TablesSelector.this.selected.clear();
                            selectedTablesModel.fireTableDataChanged();
                            UI.this.doSelectionChanged(TablesSelector.this.selected);
                        }
                    });
                }
            };
            filteringToolbar.add(this.selectAll);
            this.unselectAll = new SmallButton(" " + ACT_UNSELECT_ALL + " "){

                @Override
                protected void fireActionPerformed(ActionEvent actionEvent) {
                    super.fireActionPerformed(actionEvent);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TablesSelector.this.selected.clear();
                            TablesSelector.this.selected.addAll(Arrays.asList(TablesSelector.this.tables));
                            selectedTablesModel.fireTableDataChanged();
                            UI.this.doSelectionChanged(TablesSelector.this.selected);
                        }
                    });
                }
            };
            filteringToolbar.add(this.unselectAll);
            jPanel.add((Component)filteringToolbar, "South");
            this.panel = jPanel;
            this.updateSelectionButtons();
        }

        private void updateSelectionButtons() {
            this.selectAll.setEnabled(TablesSelector.this.selected.size() > 0);
            this.unselectAll.setEnabled(TablesSelector.this.selected.size() < TablesSelector.this.tables.length);
        }

        private void doSelectionChanged(Collection<String> collection) {
            this.updateSelectionButtons();
            TablesSelector.this.selectionChanged(collection);
        }

        private class SelectedTablesModel
        extends AbstractTableModel {
            private SelectedTablesModel() {
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return COLUMN_SELECTED;
                }
                if (n == 1) {
                    return COLUMN_TABLE;
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return Boolean.class;
                }
                if (n == 1) {
                    return Lookup.Provider.class;
                }
                return null;
            }

            @Override
            public int getRowCount() {
                return TablesSelector.this.tables.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return !TablesSelector.this.selected.contains(TablesSelector.this.tables[n]);
                }
                if (n2 == 1) {
                    return TablesSelector.this.tables[n];
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (Boolean.TRUE.equals(object)) {
                    if (TablesSelector.this.selected.remove(TablesSelector.this.tables[n])) {
                        UI.this.doSelectionChanged(TablesSelector.this.selected);
                    }
                } else if (TablesSelector.this.selected.add(TablesSelector.this.tables[n])) {
                    UI.this.doSelectionChanged(TablesSelector.this.selected);
                }
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        }
    }
}

