/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import esmska.Context;
import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Keyring;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.data.Tuple;
import esmska.data.event.AbstractDocumentListener;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.gui.CountryPrefixPanel;
import esmska.gui.GatewayComboBox;
import esmska.gui.InfoLabel;
import esmska.gui.NotificationIcon;
import esmska.gui.SignatureComboBox;
import esmska.gui.ThemeManager;
import esmska.transfer.ProxyManager;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import esmska.utils.RuntimeUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.openide.awt.Mnemonics;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.api.skin.SkinInfo;

public class ConfigFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ConfigFrame.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Keyring keyring = Keyring.getInstance();
    private static final Gateways gateways = Gateways.getInstance();
    private boolean fullyInicialized;
    private DefaultComboBoxModel lafModel = new DefaultComboBoxModel();
    private Character passwordEchoChar;
    private static final HashSet<String> restartRequests = new HashSet();
    private static final HashMap<String, Object> originalSettings = new HashMap();
    private final GatewayTableModel gwTableModel = new GatewayTableModel();
    private final GatewaySelectionListener gwSelectionListener = new GatewaySelectionListener();
    private Popup senderNamePopup;
    private JCheckBox advancedCheckBox;
    private JCheckBox advancedControlsCheckBox;
    private JCheckBox announceProgramUpdatesCheckBox;
    private JPanel appearancePanel;
    private JButton clearKeyringButton;
    private JButton closeButton;
    private Config config;
    private JPanel connectionPanel;
    private CountryPrefixPanel countryPrefixPanel;
    private JCheckBox debugCheckBox;
    private JCheckBox demandDeliveryReportCheckBox;
    private JPanel gatewayPanel;
    private JTable gatewayTable;
    private JPanel generalPanel;
    private JPanel gwDetailsPanel;
    private InfoLabel gwTipLabel;
    private JTextField httpProxyTextField;
    private JTextField httpsProxyTextField;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JComboBox lafComboBox;
    private JLabel logLocationLabel;
    private JTextField loginField;
    private JLabel lookLabel;
    private JCheckBox notificationAreaCheckBox;
    private JPasswordField passwordField;
    private JPanel privacyPanel;
    private JCheckBox reducedHistoryCheckBox;
    private JSpinner reducedHistorySpinner;
    private JCheckBox removeAccentsCheckBox;
    private InfoLabel restartLabel;
    private JCheckBox sameProxyCheckBox;
    private JLabel senderNameLabel;
    private JTextField senderNameTextField;
    private JLabel senderNumberLabel;
    private JTextField senderNumberTextField;
    private JLabel senderNumberWarnLabel;
    private JCheckBox showPasswordCheckBox;
    private JButton sigDelButton;
    private SignatureComboBox signatureComboBox;
    private JTextField socksProxyTextField;
    private JCheckBox startMinimizedCheckBox;
    private JTabbedPane tabbedPane;
    private JComboBox themeComboBox;
    private JLabel themeLabel;
    private JCheckBox tipsCheckBox;
    private JCheckBox toolbarVisibleCheckBox;
    private JCheckBox unstableUpdatesCheckBox;
    private JCheckBox useProxyCheckBox;
    private JCheckBox windowCenteredCheckBox;
    private BindingGroup bindingGroup;

    public ConfigFrame() {
        this.initComponents();
        ArrayList<Image> images = new ArrayList<Image>();
        images.add(Icons.get("config-16.png").getImage());
        images.add(Icons.get("config-32.png").getImage());
        images.add(Icons.get("config-48.png").getImage());
        this.setIconImages(images);
        String command = "close";
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), command);
        this.getRootPane().getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.this.closeButtonActionPerformed(e);
            }
        });
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            L10N.setLocalizedText(this.tabbedPane, i, this.tabbedPane.getTitleAt(i));
        }
        for (ThemeManager.LAF laf : ThemeManager.LAF.values()) {
            if (!ThemeManager.isLaFSupported(laf)) continue;
            this.lafModel.addElement(laf);
        }
        ThemeManager.LAF laf = this.config.getLookAndFeel();
        if (this.lafModel.getIndexOf((Object)laf) >= 0) {
            this.lafModel.setSelectedItem((Object)laf);
        } else {
            logger.warning("Chosen LaF '" + (Object)((Object)laf) + "' not present in the list of available LaFs!");
        }
        this.updateThemeComboBox();
        this.updateUnstableUpdateCheckbox();
        this.updateInfoLabel();
        this.updateSenderNumberWarnLabel();
        if (!NotificationIcon.isSupported()) {
            this.notificationAreaCheckBox.setSelected(false);
        }
        this.countryPrefixPanel.setCountryPrefix(this.config.getCountryPrefix());
        TableCellRenderer headerRenderer = this.gatewayTable.getTableHeader().getDefaultRenderer();
        TableColumnModel columnModel = this.gatewayTable.getColumnModel();
        int colsWidth = 0;
        for (int i = 0; i <= 1; ++i) {
            TableColumn column = columnModel.getColumn(i);
            Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
            int headerWidth = comp.getPreferredSize().width + 10;
            column.setPreferredWidth(headerWidth);
            colsWidth += headerWidth;
        }
        columnModel.getColumn(2).setPreferredWidth(this.gatewayTable.getWidth() - colsWidth);
        columnModel.getColumn(1).setCellRenderer(new FavoriteGwRenderer());
        columnModel.getColumn(2).setCellRenderer(new GatewayRenderer());
        FavoriteGwListener favoriteGwListener = new FavoriteGwListener();
        this.gatewayTable.addMouseListener(favoriteGwListener);
        this.gatewayTable.addKeyListener(favoriteGwListener.keyListener);
        this.gatewayTable.getSelectionModel().addListSelectionListener(this.gwSelectionListener);
        this.senderNumberTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateSenderNumberWarnLabel();
            }
        });
        this.senderNameTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateSenderNamePopup(PopupUpdateType.UPDATE);
            }
        });
        AbstractDocumentListener keyringListener = new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateKeyring();
            }
        };
        this.loginField.getDocument().addDocumentListener(keyringListener);
        this.passwordField.getDocument().addDocumentListener(keyringListener);
        AbstractDocumentListener signatureListener = new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateSignature();
            }
        };
        this.senderNumberTextField.getDocument().addDocumentListener(signatureListener);
        this.senderNameTextField.getDocument().addDocumentListener(signatureListener);
        this.advancedCheckBoxActionPerformed(null);
        if (!originalSettings.containsKey("debugMode")) {
            originalSettings.put("debugMode", this.config.isDebugMode());
        }
        this.fullyInicialized = true;
        if (this.gwTableModel.getRowCount() > 0) {
            this.gatewayTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void switchToTab(Tabs tab) {
        JPanel comp = null;
        switch (tab) {
            case GENERAL: {
                comp = this.generalPanel;
                break;
            }
            case APPEARANCE: {
                comp = this.appearancePanel;
                break;
            }
            case GATEWAYS: {
                comp = this.gatewayPanel;
                break;
            }
            case PRIVACY: {
                comp = this.privacyPanel;
                break;
            }
            case CONNECTION: {
                comp = this.connectionPanel;
                break;
            }
            default: {
                logger.warning("Unknown tab: " + (Object)((Object)tab));
                assert (false) : "Unknown tab: " + (Object)((Object)tab);
                break;
            }
        }
        this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfComponent(comp));
    }

    private void updateInfoLabel() {
        boolean wasVisible = this.restartLabel.isVisible();
        this.restartLabel.setVisible(!restartRequests.isEmpty());
        if (!this.fullyInicialized) {
            return;
        }
        if (!wasVisible && this.restartLabel.isVisible()) {
            this.invalidate();
            this.validate();
            if (MiscUtils.isCropped(this.closeButton)) {
                this.pack();
            }
        }
    }

    private void updateThemeComboBox() {
        boolean temp = this.fullyInicialized;
        this.fullyInicialized = false;
        this.themeComboBox.setEnabled(false);
        ThemeManager.LAF laf = (ThemeManager.LAF)((Object)this.lafComboBox.getSelectedItem());
        if (laf.equals((Object)ThemeManager.LAF.JGOODIES)) {
            ArrayList<String> themes = new ArrayList<String>();
            for (Object o : PlasticLookAndFeel.getInstalledThemes()) {
                themes.add(((PlasticTheme)o).getName());
            }
            this.themeComboBox.setModel(new DefaultComboBoxModel<Object>(themes.toArray()));
            this.themeComboBox.setSelectedItem(this.config.getLafJGoodiesTheme());
            this.themeComboBox.setEnabled(true);
        } else if (laf.equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ArrayList<String> themes = new ArrayList<String>();
            for (SkinInfo skinInfo : SubstanceLookAndFeel.getAllSkins().values()) {
                themes.add(skinInfo.getDisplayName());
            }
            this.themeComboBox.setModel(new DefaultComboBoxModel<Object>(themes.toArray()));
            this.themeComboBox.setSelectedItem(this.config.getLafSubstanceSkin());
            this.themeComboBox.setEnabled(true);
        }
        this.fullyInicialized = temp;
    }

    private void updateKeyring() {
        Gateway gateway;
        if (!this.fullyInicialized) {
            return;
        }
        int row = this.gatewayTable.getSelectedRow();
        Gateway gateway2 = gateway = row >= 0 ? this.gwTableModel.getGateway(row) : null;
        if (gateway == null) {
            return;
        }
        Tuple<String, String> key = new Tuple<String, String>(this.loginField.getText(), new String(this.passwordField.getPassword()));
        if (StringUtils.isEmpty(key.get1()) && StringUtils.isEmpty(key.get2())) {
            keyring.removeKey(gateway.getName());
        } else {
            keyring.putKey(gateway.getName(), key);
        }
    }

    private void updateProxy() {
        if (!this.fullyInicialized) {
            return;
        }
        boolean useProxy = this.useProxyCheckBox.isSelected();
        if (useProxy) {
            ProxyManager.setProxy(this.httpProxyTextField.getText(), this.httpsProxyTextField.getText(), this.socksProxyTextField.getText());
        } else {
            ProxyManager.setProxy(null, null, null);
        }
    }

    private void updateUnstableUpdateCheckbox() {
        if (!Config.isStableVersion()) {
            this.unstableUpdatesCheckBox.setEnabled(false);
        } else {
            this.unstableUpdatesCheckBox.setEnabled(this.announceProgramUpdatesCheckBox.isSelected());
        }
    }

    private void updateSenderNumberWarnLabel() {
        String number = this.senderNumberTextField.getText();
        if (StringUtils.isEmpty(number) || Contact.isValidNumber(number) || !this.senderNumberTextField.isEnabled()) {
            this.senderNumberWarnLabel.setVisible(false);
        } else {
            this.senderNumberWarnLabel.setVisible(true);
        }
    }

    private void updateSenderNamePopup(PopupUpdateType updateType) {
        if (this.senderNamePopup != null) {
            this.senderNamePopup.hide();
        }
        if (updateType == PopupUpdateType.SHOW || updateType == PopupUpdateType.UPDATE && this.senderNamePopup != null) {
            String signature = MiscUtils.escapeHtml(this.senderNameTextField.getText());
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(MessageFormat.format(l10n.getString("ConfigFrame.senderNamePopup.exampleText"), signature));
            toolTip.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ConfigFrame.this.senderNamePopup != null) {
                        ConfigFrame.this.senderNamePopup.hide();
                    }
                }
            });
            int x = this.senderNameLabel.getLocationOnScreen().x + this.senderNameTextField.getHeight() / 2;
            int y = this.senderNameTextField.getLocationOnScreen().y + this.senderNameTextField.getHeight() - 2;
            this.senderNamePopup = PopupFactory.getSharedInstance().getPopup(this.senderNameTextField, toolTip, x, y);
            this.senderNamePopup.show();
        } else {
            this.senderNamePopup = null;
        }
    }

    private void updateSignature() {
        if (!this.fullyInicialized) {
            return;
        }
        Signature signature = this.signatureComboBox.getSelectedSignature();
        if (signature == null) {
            return;
        }
        String number = this.senderNumberTextField.getText();
        String name = this.senderNameTextField.getText();
        signature.setUserName(name);
        signature.setUserNumber(number);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.config = Config.getInstance();
        this.tabbedPane = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.removeAccentsCheckBox = new JCheckBox();
        this.announceProgramUpdatesCheckBox = new JCheckBox();
        this.unstableUpdatesCheckBox = new JCheckBox();
        this.debugCheckBox = new JCheckBox();
        this.logLocationLabel = new JLabel();
        this.countryPrefixPanel = new CountryPrefixPanel();
        this.appearancePanel = new JPanel();
        this.lafComboBox = new JComboBox();
        this.lookLabel = new JLabel();
        this.themeComboBox = new JComboBox();
        this.themeLabel = new JLabel();
        this.windowCenteredCheckBox = new JCheckBox();
        this.toolbarVisibleCheckBox = new JCheckBox();
        this.notificationAreaCheckBox = new JCheckBox();
        this.tipsCheckBox = new JCheckBox();
        this.startMinimizedCheckBox = new JCheckBox();
        this.advancedControlsCheckBox = new JCheckBox();
        this.gatewayPanel = new JPanel();
        this.clearKeyringButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.gatewayTable = new JTable(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = this.getSelectedRow();
                int column = this.getSelectedColumn();
                super.tableChanged(e);
                if (row < this.getRowCount() && column < this.getColumnCount()) {
                    this.changeSelection(row, column, false, false);
                }
            }
        };
        this.gwTipLabel = new InfoLabel(InfoLabel.Type.TIP);
        this.gwDetailsPanel = new JPanel();
        this.passwordField = new JPasswordField();
        this.jLabel12 = new JLabel();
        this.loginField = new JTextField();
        this.showPasswordCheckBox = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.signatureComboBox = new SignatureComboBox();
        this.jLabel2 = new JLabel();
        this.sigDelButton = new JButton();
        this.senderNumberTextField = new JTextField();
        this.senderNameTextField = new JTextField();
        this.demandDeliveryReportCheckBox = new JCheckBox();
        this.senderNumberLabel = new JLabel();
        this.senderNameLabel = new JLabel();
        this.senderNumberWarnLabel = new JLabel();
        this.privacyPanel = new JPanel();
        this.reducedHistoryCheckBox = new JCheckBox();
        this.reducedHistorySpinner = new JSpinner();
        this.jLabel18 = new JLabel();
        this.connectionPanel = new JPanel();
        this.useProxyCheckBox = new JCheckBox();
        this.httpProxyTextField = new JTextField();
        this.sameProxyCheckBox = new JCheckBox();
        this.httpsProxyTextField = new JTextField();
        this.socksProxyTextField = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.closeButton = new JButton();
        this.advancedCheckBox = new JCheckBox();
        this.restartLabel = new InfoLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(l10n.getString("ConfigFrame.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConfigFrame.this.formWindowClosing(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ConfigFrame.this.formComponentShown(evt);
            }
        });
        Mnemonics.setLocalizedText(this.removeAccentsCheckBox, l10n.getString("ConfigFrame.removeAccentsCheckBox.text"));
        this.removeAccentsCheckBox.setToolTipText(l10n.getString("ConfigFrame.removeAccentsCheckBox.toolTipText"));
        AutoBinding binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${removeAccents}"), this.removeAccentsCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.announceProgramUpdatesCheckBox, l10n.getString("ConfigFrame.announceProgramUpdatesCheckBox.text"));
        this.announceProgramUpdatesCheckBox.setToolTipText(l10n.getString("ConfigFrame.announceProgramUpdatesCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${announceProgramUpdates}"), this.announceProgramUpdatesCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.announceProgramUpdatesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.announceProgramUpdatesCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.unstableUpdatesCheckBox, l10n.getString("ConfigFrame.unstableUpdatesCheckBox.text"));
        this.unstableUpdatesCheckBox.setToolTipText(l10n.getString("ConfigFrame.unstableUpdatesCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${announceUnstableUpdates}"), this.unstableUpdatesCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.debugCheckBox, l10n.getString("ConfigFrame.debugCheckBox.text"));
        this.debugCheckBox.setToolTipText(l10n.getString("ConfigFrame.debugCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${debugMode}"), this.debugCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.debugCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigFrame.this.debugCheckBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText(this.logLocationLabel, l10n.getString("ConfigFrame.logLocationLabel.text"));
        this.logLocationLabel.setText(MessageFormat.format(this.logLocationLabel.getText(), Context.persistenceManager.getLogFile()));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.debugCheckBox, BeanProperty.create("selected"), this.logLocationLabel, BeanProperty.create("visible"));
        this.bindingGroup.addBinding(binding);
        GroupLayout generalPanelLayout = new GroupLayout(this.generalPanel);
        this.generalPanel.setLayout(generalPanelLayout);
        generalPanelLayout.setHorizontalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.countryPrefixPanel, -2, -1, -2).addComponent(this.removeAccentsCheckBox).addComponent(this.announceProgramUpdatesCheckBox).addComponent(this.debugCheckBox).addGroup(generalPanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.unstableUpdatesCheckBox).addComponent(this.logLocationLabel, -2, -1, -2)))).addContainerGap(363, Short.MAX_VALUE)));
        generalPanelLayout.setVerticalGroup(generalPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.countryPrefixPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeAccentsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.announceProgramUpdatesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unstableUpdatesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logLocationLabel, -2, -1, -2).addContainerGap(261, Short.MAX_VALUE)));
        this.tabbedPane.addTab(l10n.getString("ConfigFrame.generalPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/esmska/resources/config-16.png")), this.generalPanel);
        this.lafComboBox.setModel(this.lafModel);
        this.lafComboBox.setToolTipText(l10n.getString("ConfigFrame.lafComboBox.toolTipText"));
        this.lafComboBox.setRenderer(new LaFComboRenderer());
        this.lafComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.lafComboBoxActionPerformed(evt);
            }
        });
        this.lookLabel.setLabelFor(this.lafComboBox);
        Mnemonics.setLocalizedText(this.lookLabel, l10n.getString("ConfigFrame.lookLabel.text"));
        this.lookLabel.setToolTipText(this.lafComboBox.getToolTipText());
        this.themeComboBox.setToolTipText(l10n.getString("ConfigFrame.themeComboBox.toolTipText"));
        this.themeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.themeComboBoxActionPerformed(evt);
            }
        });
        this.themeLabel.setLabelFor(this.themeComboBox);
        Mnemonics.setLocalizedText(this.themeLabel, l10n.getString("ConfigFrame.themeLabel.text"));
        this.themeLabel.setToolTipText(this.themeComboBox.getToolTipText());
        Mnemonics.setLocalizedText(this.windowCenteredCheckBox, l10n.getString("ConfigFrame.windowCenteredCheckBox.text"));
        this.windowCenteredCheckBox.setToolTipText(l10n.getString("ConfigFrame.windowCenteredCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${startCentered}"), this.windowCenteredCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.toolbarVisibleCheckBox, l10n.getString("ConfigFrame.toolbarVisibleCheckBox.text"));
        this.toolbarVisibleCheckBox.setToolTipText(l10n.getString("ConfigFrame.toolbarVisibleCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${toolbarVisible}"), this.toolbarVisibleCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.notificationAreaCheckBox, l10n.getString("ConfigFrame.notificationAreaCheckBox.text"));
        this.notificationAreaCheckBox.setToolTipText(l10n.getString("ConfigFrame.notificationAreaCheckBox.toolTipText"));
        this.notificationAreaCheckBox.setEnabled(NotificationIcon.isSupported());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${notificationIconVisible}"), this.notificationAreaCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.notificationAreaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.notificationAreaCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.tipsCheckBox, l10n.getString("ConfigFrame.tipsCheckBox.text"));
        this.tipsCheckBox.setToolTipText(l10n.getString("ConfigFrame.tipsCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${showTips}"), this.tipsCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.startMinimizedCheckBox, l10n.getString("ConfigFrame.startMinimizedCheckBox.text"));
        this.startMinimizedCheckBox.setToolTipText(l10n.getString("ConfigFrame.startMinimizedCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${startMinimized}"), this.startMinimizedCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.notificationAreaCheckBox, ELProperty.create("${selected && enabled}"), this.startMinimizedCheckBox, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        Mnemonics.setLocalizedText(this.advancedControlsCheckBox, l10n.getString("ConfigFrame.advancedControlsCheckBox.text"));
        this.advancedControlsCheckBox.setToolTipText(l10n.getString("ConfigFrame.advancedControlsCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${showAdvancedControls}"), this.advancedControlsCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        GroupLayout appearancePanelLayout = new GroupLayout(this.appearancePanel);
        this.appearancePanel.setLayout(appearancePanelLayout);
        appearancePanelLayout.setHorizontalGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(appearancePanelLayout.createSequentialGroup().addContainerGap().addGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(appearancePanelLayout.createSequentialGroup().addComponent(this.lookLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lafComboBox, -2, -1, -2)).addGroup(appearancePanelLayout.createSequentialGroup().addComponent(this.themeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.themeComboBox, -2, -1, -2)).addComponent(this.windowCenteredCheckBox).addGroup(appearancePanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.startMinimizedCheckBox)).addComponent(this.tipsCheckBox).addComponent(this.notificationAreaCheckBox).addComponent(this.toolbarVisibleCheckBox).addComponent(this.advancedControlsCheckBox)).addContainerGap(455, Short.MAX_VALUE)));
        appearancePanelLayout.linkSize(0, this.lafComboBox, this.themeComboBox);
        appearancePanelLayout.linkSize(0, this.lookLabel, this.themeLabel);
        appearancePanelLayout.setVerticalGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(appearancePanelLayout.createSequentialGroup().addContainerGap().addGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lookLabel).addComponent(this.lafComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(appearancePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.themeLabel).addComponent(this.themeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.windowCenteredCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolbarVisibleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.notificationAreaCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startMinimizedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tipsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.advancedControlsCheckBox).addContainerGap(205, Short.MAX_VALUE)));
        appearancePanelLayout.linkSize(1, this.lafComboBox, this.themeComboBox);
        this.tabbedPane.addTab(l10n.getString("ConfigFrame.appearancePanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/esmska/resources/appearance-16.png")), this.appearancePanel);
        this.clearKeyringButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/clear-22.png")));
        Mnemonics.setLocalizedText(this.clearKeyringButton, l10n.getString("ConfigFrame.clearKeyringButton.text"));
        this.clearKeyringButton.setToolTipText(l10n.getString("ConfigFrame.clearKeyringButton.toolTipText"));
        this.clearKeyringButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.clearKeyringButtonActionPerformed(evt);
            }
        });
        this.gatewayTable.setModel(this.gwTableModel);
        this.gatewayTable.setSelectionMode(0);
        this.gatewayTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.gatewayTable);
        Mnemonics.setLocalizedText(this.gwTipLabel, l10n.getString("ConfigFrame.gwTipLabel.text"));
        this.gwDetailsPanel.setBorder(BorderFactory.createTitledBorder("<<Gateway name>>"));
        this.gwDetailsPanel.setVisible(false);
        this.passwordField.setColumns(12);
        this.passwordField.setToolTipText(l10n.getString("ConfigFrame.passwordField.toolTipText"));
        this.passwordField.enableInputMethods(true);
        this.jLabel12.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText(this.jLabel12, l10n.getString("ConfigFrame.jLabel12.text"));
        this.jLabel12.setToolTipText(this.passwordField.getToolTipText());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.passwordField, ELProperty.create("${enabled}"), this.jLabel12, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.loginField.setColumns(12);
        this.loginField.setToolTipText(l10n.getString("ConfigFrame.loginField.toolTipText"));
        Mnemonics.setLocalizedText(this.showPasswordCheckBox, l10n.getString("ConfigFrame.showPasswordCheckBox.text"));
        this.showPasswordCheckBox.setToolTipText(l10n.getString("ConfigFrame.showPasswordCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.passwordField, ELProperty.create("${enabled}"), this.showPasswordCheckBox, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.showPasswordCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.showPasswordCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel11.setLabelFor(this.loginField);
        Mnemonics.setLocalizedText(this.jLabel11, l10n.getString("ConfigFrame.jLabel11.text"));
        this.jLabel11.setToolTipText(this.loginField.getToolTipText());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.loginField, ELProperty.create("${enabled}"), this.jLabel11, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.signatureComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.signatureComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.signatureComboBox);
        Mnemonics.setLocalizedText(this.jLabel2, l10n.getString("ConfigFrame.jLabel2.text"));
        this.jLabel2.setToolTipText(this.signatureComboBox.getToolTipText());
        this.sigDelButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/delete-16.png")));
        this.sigDelButton.setToolTipText(l10n.getString("ConfigFrame.sigDelButton.toolTipText"));
        this.sigDelButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.sigDelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.sigDelButtonActionPerformed(evt);
            }
        });
        this.senderNumberTextField.setColumns(12);
        this.senderNumberTextField.setToolTipText(l10n.getString("ConfigFrame.senderNumberTextField.toolTipText"));
        this.senderNameTextField.setColumns(12);
        this.senderNameTextField.setToolTipText(l10n.getString("ConfigFrame.senderNameTextField.toolTipText"));
        this.senderNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ConfigFrame.this.senderNameTextFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ConfigFrame.this.senderNameTextFieldFocusLost(evt);
            }
        });
        this.senderNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                ConfigFrame.this.senderNameTextFieldKeyTyped(evt);
            }
        });
        Mnemonics.setLocalizedText(this.demandDeliveryReportCheckBox, l10n.getString("ConfigFrame.demandDeliveryReportCheckBox.text"));
        this.demandDeliveryReportCheckBox.setToolTipText(l10n.getString("ConfigFrame.demandDeliveryReportCheckBox.toolTipText"));
        this.demandDeliveryReportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.demandDeliveryReportCheckBoxActionPerformed(evt);
            }
        });
        this.senderNumberLabel.setLabelFor(this.senderNumberTextField);
        Mnemonics.setLocalizedText(this.senderNumberLabel, l10n.getString("ConfigFrame.senderNumberLabel.text"));
        this.senderNumberLabel.setToolTipText(this.senderNumberTextField.getToolTipText());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.senderNumberTextField, ELProperty.create("${enabled}"), this.senderNumberLabel, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.senderNameLabel.setLabelFor(this.senderNameTextField);
        Mnemonics.setLocalizedText(this.senderNameLabel, l10n.getString("ConfigFrame.senderNameLabel.text"));
        this.senderNameLabel.setToolTipText(this.senderNameTextField.getToolTipText());
        this.senderNumberWarnLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/warning-16.png")));
        this.senderNumberWarnLabel.setToolTipText(this.senderNumberTextField.getToolTipText());
        this.senderNumberWarnLabel.setVisible(false);
        GroupLayout gwDetailsPanelLayout = new GroupLayout(this.gwDetailsPanel);
        this.gwDetailsPanel.setLayout(gwDetailsPanelLayout);
        gwDetailsPanelLayout.setHorizontalGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gwDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gwDetailsPanelLayout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loginField, -2, 1, Short.MAX_VALUE)).addGroup(gwDetailsPanelLayout.createSequentialGroup().addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showPasswordCheckBox).addComponent(this.passwordField, -2, 1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, gwDetailsPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signatureComboBox, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sigDelButton)).addGroup(gwDetailsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gwDetailsPanelLayout.createSequentialGroup().addComponent(this.senderNumberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.senderNumberTextField, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.senderNumberWarnLabel)).addGroup(gwDetailsPanelLayout.createSequentialGroup().addComponent(this.senderNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.senderNameTextField, -2, 0, Short.MAX_VALUE)))).addComponent(this.demandDeliveryReportCheckBox)).addContainerGap()));
        gwDetailsPanelLayout.linkSize(0, this.jLabel11, this.jLabel12);
        gwDetailsPanelLayout.linkSize(0, this.senderNameLabel, this.senderNumberLabel);
        gwDetailsPanelLayout.setVerticalGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gwDetailsPanelLayout.createSequentialGroup().addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.loginField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPasswordCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sigDelButton).addComponent(this.signatureComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.senderNumberLabel).addComponent(this.senderNumberTextField, -2, -1, -2).addComponent(this.senderNumberWarnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gwDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.senderNameLabel).addComponent(this.senderNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.demandDeliveryReportCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout gatewayPanelLayout = new GroupLayout(this.gatewayPanel);
        this.gatewayPanel.setLayout(gatewayPanelLayout);
        gatewayPanelLayout.setHorizontalGroup(gatewayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gatewayPanelLayout.createSequentialGroup().addContainerGap().addGroup(gatewayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, gatewayPanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 473, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gatewayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clearKeyringButton).addComponent(this.gwDetailsPanel, -2, -1, -2))).addComponent(this.gwTipLabel, -1, 712, Short.MAX_VALUE)).addContainerGap()));
        gatewayPanelLayout.setVerticalGroup(gatewayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gatewayPanelLayout.createSequentialGroup().addContainerGap().addGroup(gatewayPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gatewayPanelLayout.createSequentialGroup().addComponent(this.gwDetailsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearKeyringButton)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gwTipLabel, -2, -1, -2).addContainerGap()));
        this.tabbedPane.addTab(l10n.getString("ConfigFrame.gatewayPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/esmska/resources/gateway-16.png")), this.gatewayPanel);
        Mnemonics.setLocalizedText(this.reducedHistoryCheckBox, l10n.getString("ConfigFrame.reducedHistoryCheckBox.text"));
        this.reducedHistoryCheckBox.setToolTipText(l10n.getString("ConfigFrame.reducedHistoryCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${reducedHistory}"), this.reducedHistoryCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.reducedHistoryCheckBox.setText(this.reducedHistoryCheckBox.getText().replaceFirst("\\{0\\}.*$", "").trim());
        this.reducedHistorySpinner.setToolTipText(this.reducedHistoryCheckBox.getToolTipText());
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${reducedHistoryCount}"), this.reducedHistorySpinner, BeanProperty.create("value"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.reducedHistoryCheckBox, ELProperty.create("${selected}"), this.reducedHistorySpinner, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        ((SpinnerNumberModel)this.reducedHistorySpinner.getModel()).setMinimum(new Integer(0));
        Mnemonics.setLocalizedText(this.jLabel18, "<<days.>>");
        this.jLabel18.setToolTipText(this.reducedHistoryCheckBox.getToolTipText());
        this.jLabel18.setText(l10n.getString("ConfigFrame.reducedHistoryCheckBox.text").replaceFirst("^.*\\{0\\}", "").trim());
        GroupLayout privacyPanelLayout = new GroupLayout(this.privacyPanel);
        this.privacyPanel.setLayout(privacyPanelLayout);
        privacyPanelLayout.setHorizontalGroup(privacyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(privacyPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reducedHistoryCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reducedHistorySpinner, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18).addContainerGap(196, Short.MAX_VALUE)));
        privacyPanelLayout.setVerticalGroup(privacyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(privacyPanelLayout.createSequentialGroup().addContainerGap().addGroup(privacyPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reducedHistoryCheckBox).addComponent(this.reducedHistorySpinner, -2, -1, -2).addComponent(this.jLabel18)).addContainerGap()));
        this.tabbedPane.addTab(l10n.getString("ConfigFrame.privacyPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/esmska/resources/lock-16.png")), this.privacyPanel);
        Mnemonics.setLocalizedText(this.useProxyCheckBox, l10n.getString("ConfigFrame.useProxyCheckBox.text"));
        this.useProxyCheckBox.setToolTipText(l10n.getString("ConfigFrame.useProxyCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${useProxy}"), this.useProxyCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.useProxyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigFrame.this.useProxyCheckBoxItemStateChanged(evt);
            }
        });
        this.httpProxyTextField.setColumns(20);
        this.httpProxyTextField.setToolTipText(l10n.getString("ConfigFrame.httpProxyTextField.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${httpProxy}"), this.httpProxyTextField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.useProxyCheckBox, ELProperty.create("${selected}"), this.httpProxyTextField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.httpProxyTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                if (ConfigFrame.this.sameProxyCheckBox.isSelected()) {
                    ConfigFrame.this.httpsProxyTextField.setText(ConfigFrame.this.httpProxyTextField.getText());
                }
                ConfigFrame.this.updateProxy();
            }
        });
        Mnemonics.setLocalizedText(this.sameProxyCheckBox, l10n.getString("ConfigFrame.sameProxyCheckBox.text"));
        this.sameProxyCheckBox.setToolTipText(l10n.getString("ConfigFrame.sameProxyCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${sameProxy}"), this.sameProxyCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.useProxyCheckBox, ELProperty.create("${selected}"), this.sameProxyCheckBox, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.sameProxyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigFrame.this.sameProxyCheckBoxItemStateChanged(evt);
            }
        });
        this.httpsProxyTextField.setToolTipText(l10n.getString("ConfigFrame.httpsProxyTextField.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${httpsProxy}"), this.httpsProxyTextField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.sameProxyCheckBox, ELProperty.create("${enabled && !selected}"), this.httpsProxyTextField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.httpsProxyTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateProxy();
            }
        });
        this.socksProxyTextField.setToolTipText(l10n.getString("ConfigFrame.socksProxyTextField.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${socksProxy}"), this.socksProxyTextField, BeanProperty.create("text"));
        this.bindingGroup.addBinding(binding);
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ, this.sameProxyCheckBox, ELProperty.create("${enabled}"), this.socksProxyTextField, BeanProperty.create("enabled"));
        this.bindingGroup.addBinding(binding);
        this.socksProxyTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                ConfigFrame.this.updateProxy();
            }
        });
        this.jLabel14.setLabelFor(this.httpProxyTextField);
        Mnemonics.setLocalizedText(this.jLabel14, l10n.getString("ConfigFrame.jLabel14.text"));
        this.jLabel14.setToolTipText(this.httpProxyTextField.getToolTipText());
        this.jLabel15.setLabelFor(this.httpsProxyTextField);
        Mnemonics.setLocalizedText(this.jLabel15, l10n.getString("ConfigFrame.jLabel15.text"));
        this.jLabel15.setToolTipText(this.httpsProxyTextField.getToolTipText());
        this.jLabel16.setLabelFor(this.socksProxyTextField);
        Mnemonics.setLocalizedText(this.jLabel16, l10n.getString("ConfigFrame.jLabel16.text"));
        this.jLabel16.setToolTipText(this.socksProxyTextField.getToolTipText());
        Mnemonics.setLocalizedText(this.jLabel17, l10n.getString("ConfigFrame.jLabel17.text"));
        GroupLayout connectionPanelLayout = new GroupLayout(this.connectionPanel);
        this.connectionPanel.setLayout(connectionPanelLayout);
        connectionPanelLayout.setHorizontalGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionPanelLayout.createSequentialGroup().addContainerGap().addGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useProxyCheckBox).addGroup(connectionPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(connectionPanelLayout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.httpProxyTextField, -2, -1, -2)).addGroup(connectionPanelLayout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.socksProxyTextField)).addGroup(GroupLayout.Alignment.TRAILING, connectionPanelLayout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.httpsProxyTextField)).addGroup(connectionPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.sameProxyCheckBox)))).addComponent(this.jLabel17, -1, 712, Short.MAX_VALUE)).addContainerGap()));
        connectionPanelLayout.linkSize(0, this.jLabel14, this.jLabel15, this.jLabel16);
        connectionPanelLayout.linkSize(0, this.httpProxyTextField, this.httpsProxyTextField, this.socksProxyTextField);
        connectionPanelLayout.setVerticalGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(connectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.useProxyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.httpProxyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.httpsProxyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sameProxyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(connectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.socksProxyTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 243, Short.MAX_VALUE).addComponent(this.jLabel17, -2, -1, -2).addContainerGap()));
        connectionPanelLayout.linkSize(1, this.httpProxyTextField, this.httpsProxyTextField, this.socksProxyTextField);
        this.tabbedPane.addTab(l10n.getString("ConfigFrame.connectionPanel.TabConstraints.tabTitle"), new ImageIcon(this.getClass().getResource("/esmska/resources/connection-16.png")), this.connectionPanel);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/close-22.png")));
        Mnemonics.setLocalizedText(this.closeButton, l10n.getString("Close_"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.closeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.advancedCheckBox, l10n.getString("ConfigFrame.advancedCheckBox.text"));
        this.advancedCheckBox.setToolTipText(l10n.getString("ConfigFrame.advancedCheckBox.toolTipText"));
        binding = Bindings.createAutoBinding(AutoBinding.UpdateStrategy.READ_WRITE, this.config, ELProperty.create("${showAdvancedSettings}"), this.advancedCheckBox, BeanProperty.create("selected"));
        this.bindingGroup.addBinding(binding);
        this.advancedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigFrame.this.advancedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText(this.restartLabel, l10n.getString("ConfigFrame.restartLabel.text"));
        this.restartLabel.setVisible(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.advancedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeButton)).addComponent(this.restartLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restartLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.advancedCheckBox)).addContainerGap()));
        this.bindingGroup.bind();
        this.pack();
    }

    private void themeComboBoxActionPerformed(ActionEvent evt) {
        ThemeManager.LAF laf = (ThemeManager.LAF)((Object)this.lafComboBox.getSelectedItem());
        if (laf.equals((Object)ThemeManager.LAF.JGOODIES)) {
            this.config.setLafJGoodiesTheme((String)this.themeComboBox.getSelectedItem());
        } else if (laf.equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            this.config.setLafSubstanceSkin((String)this.themeComboBox.getSelectedItem());
        }
        if (this.fullyInicialized && ThemeManager.getActiveLaF() == this.lafComboBox.getSelectedItem()) {
            logger.fine("Changing LaF theme in realtime...");
            try {
                ThemeManager.setLaF();
                SwingUtilities.updateComponentTreeUI(Context.mainFrame);
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "Problem while live-updating the look&feel skin", ex);
            }
        }
    }

    private void lafComboBoxActionPerformed(ActionEvent evt) {
        if (!this.fullyInicialized) {
            return;
        }
        ThemeManager.LAF laf = (ThemeManager.LAF)((Object)this.lafComboBox.getSelectedItem());
        this.config.setLookAndFeel(laf);
        this.updateThemeComboBox();
        if (laf != ThemeManager.getActiveLaF()) {
            restartRequests.add("lafComboBox");
        } else {
            restartRequests.remove("lafComboBox");
        }
        this.updateInfoLabel();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.formWindowClosing(null);
        this.setVisible(false);
        this.dispose();
    }

    private void clearKeyringButtonActionPerformed(ActionEvent evt) {
        String deleteOption = l10n.getString("Delete");
        String cancelOption = l10n.getString("Cancel");
        Object[] options = RuntimeUtils.sortDialogOptions(cancelOption, deleteOption);
        String message = l10n.getString("ConfigFrame.remove_credentials");
        JOptionPane pane = new JOptionPane(message, 2, -1, null, options, cancelOption);
        JDialog dialog = pane.createDialog(this, null);
        dialog.setResizable(true);
        RuntimeUtils.setDocumentModalDialog(dialog);
        dialog.pack();
        dialog.setVisible(true);
        if (!deleteOption.equals(pane.getValue())) {
            return;
        }
        keyring.clearKeys();
        this.gwSelectionListener.valueChanged(new ListSelectionEvent(this.gatewayTable, 0, 0, false));
    }

    private void useProxyCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateProxy();
    }

    private void sameProxyCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateProxy();
    }

    private void notificationAreaCheckBoxActionPerformed(ActionEvent evt) {
        if (this.notificationAreaCheckBox.isSelected()) {
            NotificationIcon.install();
        } else {
            NotificationIcon.uninstall();
        }
    }

    private void advancedCheckBoxActionPerformed(ActionEvent evt) {
        boolean showAdvanced = this.advancedCheckBox.isSelected();
        this.announceProgramUpdatesCheckBox.setVisible(showAdvanced);
        this.unstableUpdatesCheckBox.setVisible(showAdvanced);
        this.windowCenteredCheckBox.setVisible(showAdvanced);
        this.startMinimizedCheckBox.setVisible(showAdvanced);
        this.tipsCheckBox.setVisible(showAdvanced);
        this.debugCheckBox.setVisible(showAdvanced);
        this.advancedControlsCheckBox.setVisible(showAdvanced);
        this.toolbarVisibleCheckBox.setVisible(showAdvanced);
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.privacyPanel), showAdvanced);
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfComponent(this.connectionPanel), showAdvanced);
        this.invalidate();
        this.validate();
    }

    private void showPasswordCheckBoxActionPerformed(ActionEvent evt) {
        if (this.showPasswordCheckBox.isSelected()) {
            this.passwordEchoChar = Character.valueOf(this.passwordField.getEchoChar());
            this.passwordField.setEchoChar('\u0000');
        } else {
            this.passwordField.setEchoChar(((Character)ObjectUtils.defaultIfNull(this.passwordEchoChar, Character.valueOf('*'))).charValue());
        }
    }

    private void announceProgramUpdatesCheckBoxActionPerformed(ActionEvent evt) {
        this.updateUnstableUpdateCheckbox();
    }

    private void debugCheckBoxItemStateChanged(ItemEvent evt) {
        if (!this.fullyInicialized) {
            return;
        }
        if (this.debugCheckBox.isSelected() != ((Boolean)originalSettings.get("debugMode")).booleanValue()) {
            restartRequests.add("debugCheckBox");
        } else {
            restartRequests.remove("debugCheckBox");
        }
        this.updateInfoLabel();
    }

    private void formWindowClosing(WindowEvent evt) {
        String prefix = this.countryPrefixPanel.getCountryPrefix();
        if (prefix != null) {
            this.config.setCountryPrefix(prefix);
        }
        this.countryPrefixPanel.setCountryPrefix(this.config.getCountryPrefix());
        try {
            Context.persistenceManager.saveConfig();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Could not save config", ex);
        }
        try {
            Context.persistenceManager.saveGatewayProperties();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not save gateway properties", ex);
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.closeButton.requestFocusInWindow();
    }

    private void signatureComboBoxActionPerformed(ActionEvent evt) {
        boolean oldInit = this.fullyInicialized;
        this.fullyInicialized = false;
        Signature signature = this.signatureComboBox.getSelectedSignature();
        String number = signature != null ? signature.getUserNumber() : null;
        String name = signature != null ? signature.getUserName() : null;
        this.senderNumberTextField.setText(number);
        this.senderNameTextField.setText(name);
        boolean editable = this.signatureComboBox.isEditableSelected();
        this.senderNumberLabel.setVisible(editable);
        this.senderNumberTextField.setVisible(editable);
        this.senderNameLabel.setVisible(editable);
        this.senderNameTextField.setVisible(editable);
        this.sigDelButton.setVisible(this.signatureComboBox.isRemovableSelected());
        int row = this.gatewayTable.getSelectedRow();
        if (row >= 0 && signature != null) {
            Gateway gw = this.gwTableModel.getGateway(row);
            gw.getConfig().setSignature(signature.getProfileName());
        }
        this.fullyInicialized = oldInit;
    }

    private void sigDelButtonActionPerformed(ActionEvent evt) {
        Signature signature = this.signatureComboBox.getSelectedSignature();
        if (signature == null) {
            return;
        }
        String deleteOption = l10n.getString("Delete");
        String cancelOption = l10n.getString("Cancel");
        Object[] options = RuntimeUtils.sortDialogOptions(cancelOption, deleteOption);
        String message = l10n.getString("Signature.confirmRemove");
        JOptionPane pane = new JOptionPane(message, 2, -1, null, options, deleteOption);
        JDialog dialog = pane.createDialog(this, null);
        dialog.setResizable(true);
        RuntimeUtils.setDocumentModalDialog(dialog);
        dialog.pack();
        dialog.setVisible(true);
        if (!deleteOption.equals(pane.getValue())) {
            return;
        }
        Signatures.getInstance().remove(signature.getProfileName());
    }

    private void demandDeliveryReportCheckBoxActionPerformed(ActionEvent evt) {
        if (!this.fullyInicialized) {
            return;
        }
        int row = this.gatewayTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        Gateway gateway = this.gwTableModel.getGateway(row);
        gateway.getConfig().setReceipt(this.demandDeliveryReportCheckBox.isSelected());
    }

    private void senderNameTextFieldFocusGained(FocusEvent evt) {
        this.updateSenderNamePopup(PopupUpdateType.SHOW);
    }

    private void senderNameTextFieldFocusLost(FocusEvent evt) {
        this.updateSenderNamePopup(PopupUpdateType.HIDE);
    }

    private void senderNameTextFieldKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c < ' ' || c == '\uffff') {
            return;
        }
        if (this.senderNameTextField.getText().length() != 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConfigFrame.this.senderNameTextField.getText().length() == 0) {
                    return;
                }
                String typed = ConfigFrame.this.senderNameTextField.getText();
                ConfigFrame.this.senderNameTextField.setText(typed + ":");
                ConfigFrame.this.senderNameTextField.setCaretPosition(typed.length());
            }
        });
    }

    private class GatewaySelectionListener
    implements ListSelectionListener {
        private GatewaySelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ConfigFrame.this.gatewayTable.getSelectedRow();
            boolean selected = row >= 0;
            ConfigFrame.this.gwDetailsPanel.setVisible(selected);
            if (!selected) {
                return;
            }
            Gateway gateway = ConfigFrame.this.gwTableModel.getGateway(row);
            boolean oldInit = ConfigFrame.this.fullyInicialized;
            ConfigFrame.this.fullyInicialized = false;
            boolean login = gateway.hasFeature(Gateway.Feature.LOGIN) || gateway.hasFeature(Gateway.Feature.LOGIN_ONLY);
            ConfigFrame.this.loginField.setEnabled(login);
            ConfigFrame.this.passwordField.setEnabled(login);
            ConfigFrame.this.senderNumberTextField.setEnabled(gateway.hasFeature(Gateway.Feature.SENDER_NUMBER));
            ConfigFrame.this.signatureComboBox.setSelectedSignature(gateway.getConfig().getSignature());
            boolean receipt = gateway.hasFeature(Gateway.Feature.RECEIPT);
            ConfigFrame.this.demandDeliveryReportCheckBox.setEnabled(receipt);
            if (receipt) {
                ConfigFrame.this.demandDeliveryReportCheckBox.setSelected(gateway.getConfig().isReceipt());
            } else {
                ConfigFrame.this.demandDeliveryReportCheckBox.setSelected(false);
            }
            Tuple<String, String> key = keyring.getKey(gateway != null ? gateway.getName() : null);
            if (key == null) {
                ConfigFrame.this.loginField.setText(null);
                ConfigFrame.this.passwordField.setText(null);
            } else {
                ConfigFrame.this.loginField.setText(key.get1());
                ConfigFrame.this.loginField.setCaretPosition(0);
                ConfigFrame.this.passwordField.setText(key.get2());
                ConfigFrame.this.passwordField.setCaretPosition(0);
            }
            TitledBorder gwDetailsBorder = (TitledBorder)ConfigFrame.this.gwDetailsPanel.getBorder();
            gwDetailsBorder.setTitle(gateway.getName());
            ConfigFrame.this.gwDetailsPanel.repaint();
            ConfigFrame.this.fullyInicialized = oldInit;
        }
    }

    private class FavoriteGwListener
    extends MouseAdapter {
        private KeyListener keyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int column;
                if (e.getModifiers() != 0 || e.getKeyCode() != 32) {
                    return;
                }
                int row = ConfigFrame.this.gatewayTable.getSelectedRow();
                if (FavoriteGwListener.this.changeValue(row, column = ConfigFrame.this.gatewayTable.getSelectedColumn())) {
                    e.consume();
                }
            }
        };

        private FavoriteGwListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            int row = ConfigFrame.this.gatewayTable.rowAtPoint(p);
            int column = ConfigFrame.this.gatewayTable.columnAtPoint(p);
            this.changeValue(row, column);
        }

        private boolean changeValue(int row, int column) {
            if (column != 1 || row < 0) {
                return false;
            }
            Boolean favorite = (Boolean)ConfigFrame.this.gwTableModel.getValueAt(row, column);
            favorite = favorite == false;
            ConfigFrame.this.gwTableModel.setValueAt(favorite, row, column);
            return true;
        }
    }

    private class GatewayRenderer
    extends SubstanceDefaultTableCellRenderer {
        private GatewayComboBox.GatewayComboBoxRenderer renderer = new GatewayComboBox.GatewayComboBoxRenderer();

        private GatewayRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!(value instanceof Gateway)) {
                return label;
            }
            this.renderer.adjustLabel(label, (Gateway)value);
            return label;
        }
    }

    private class FavoriteGwRenderer
    extends SubstanceDefaultTableCellRenderer {
        private FavoriteGwRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            label.setText(null);
            label.setHorizontalAlignment(0);
            if (((Boolean)value).booleanValue()) {
                label.setIcon(Icons.get("star-full-16.png"));
            } else {
                label.setIcon(Icons.get("star-empty-16.png"));
            }
            return label;
        }
    }

    private class GatewayTableModel
    extends AbstractTableModel {
        private ArrayList<Gateway> gws = new ArrayList<Gateway>(ConfigFrame.access$3700().getAll());

        public GatewayTableModel() {
            gateways.addValuedListener(new ValuedListener<Gateways.Events, Gateway>(){

                @Override
                public void eventOccured(ValuedEvent<Gateways.Events, Gateway> e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GatewayTableModel.this.refreshGws();
                        }
                    });
                }
            });
        }

        private void refreshGws() {
            this.gws = new ArrayList<Gateway>(gateways.getAll());
            this.fireTableDataChanged();
        }

        public Gateway getGateway(int rowIndex) {
            return this.gws.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.gws.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Gateway gw = this.gws.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return !gw.isHidden();
                }
                case 1: {
                    return gw.isFavorite();
                }
                case 2: {
                    return gw;
                }
            }
            logger.warning("Index out of bounds!");
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return l10n.getString("ConfigFrame.Show");
                }
                case 1: {
                    return l10n.getString("ConfigFrame.Favorite");
                }
                case 2: {
                    return l10n.getString("ConfigFrame.Gateway");
                }
            }
            logger.warning("Index out of bounds!");
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return Gateway.class;
                }
            }
            logger.warning("Index out of bounds!");
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Gateway gw = this.gws.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    HashSet<String> hidden = new HashSet<String>(Arrays.asList(ConfigFrame.this.config.getHiddenGateways()));
                    if (((Boolean)aValue).booleanValue()) {
                        hidden.remove(gw.getName());
                    } else {
                        hidden.add(gw.getName());
                    }
                    ConfigFrame.this.config.setHiddenGateways(hidden.toArray(new String[0]));
                    return;
                }
                case 1: {
                    HashSet<String> favorite = new HashSet<String>(Arrays.asList(ConfigFrame.this.config.getFavoriteGateways()));
                    if (((Boolean)aValue).booleanValue()) {
                        favorite.add(gw.getName());
                    } else {
                        favorite.remove(gw.getName());
                    }
                    ConfigFrame.this.config.setFavoriteGateways(favorite.toArray(new String[0]));
                    return;
                }
                case 2: {
                    logger.warning("Assignment not supported!");
                }
            }
            logger.warning("Index out of bounds!");
        }
    }

    private class LaFComboRenderer
    extends DefaultListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();
        private final String LAF_SYSTEM = ConfigFrame.access$3500().getString("ConfigFrame.system_look");
        private final String LAF_CROSSPLATFORM = ConfigFrame.access$3500().getString("ConfigFrame.multiplatform_look");
        private final String LAF_GTK = "GTK";
        private final String LAF_JGOODIES = "JGoodies";
        private final String LAF_SUBSTANCE = "Substance";

        private LaFComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof ThemeManager.LAF)) {
                return label;
            }
            ThemeManager.LAF laf = (ThemeManager.LAF)((Object)value);
            String name = l10n.getString("ConfigFrame.unknown_look");
            switch (laf) {
                case SYSTEM: {
                    name = this.LAF_SYSTEM;
                    break;
                }
                case CROSSPLATFORM: {
                    name = this.LAF_CROSSPLATFORM;
                    break;
                }
                case GTK: {
                    name = "GTK";
                    break;
                }
                case JGOODIES: {
                    name = "JGoodies";
                    break;
                }
                case SUBSTANCE: {
                    name = "Substance";
                    break;
                }
                default: {
                    logger.severe("Unknown LaF: " + (Object)((Object)laf));
                }
            }
            label.setText(name);
            return label;
        }
    }

    private static enum PopupUpdateType {
        SHOW,
        UPDATE,
        HIDE;

    }

    public static enum Tabs {
        GENERAL,
        APPEARANCE,
        GATEWAYS,
        PRIVACY,
        CONNECTION;

    }
}

