/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.fop.area.Area;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.MultiSwitch;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.WhitespaceManagementPenalty;

public class MultiSwitchLayoutManager
extends BlockStackingLayoutManager {
    private KnuthElementsGenerator knuthGen;

    public MultiSwitchLayoutManager(FObj node) {
        super(node);
        MultiSwitch multiSwitchNode = (MultiSwitch)node;
        this.knuthGen = multiSwitchNode.getAutoToggle() == 205 ? new WhitespaceManagement() : new DefaultKnuthListGenerator();
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext context, int alignment) {
        this.referenceIPD = context.getRefIPD();
        List<ListElement> knuthList = this.knuthGen.getKnuthElements(context, alignment);
        this.setFinished(true);
        return knuthList;
    }

    @Override
    public Area getParentArea(Area childArea) {
        return this.parentLayoutManager.getParentArea(childArea);
    }

    @Override
    public void addChildArea(Area childArea) {
        this.parentLayoutManager.addChildArea(childArea);
    }

    @Override
    public void addAreas(PositionIterator posIter, LayoutContext context) {
        LinkedList<Position> positionList = new LinkedList<Position>();
        while (posIter.hasNext()) {
            Position pos = posIter.next();
            if (pos instanceof WhitespaceManagementPosition) {
                positionList.addAll(((WhitespaceManagementPosition)pos).getPositionList());
                continue;
            }
            positionList.add(pos);
        }
        PositionIterator newPosIter = new PositionIterator(positionList.listIterator());
        AreaAdditionUtil.addAreas(this, newPosIter, context);
        this.flush();
    }

    private class WhitespaceManagement
    implements KnuthElementsGenerator {
        private WhitespaceManagement() {
        }

        @Override
        public List<ListElement> getKnuthElements(LayoutContext context, int alignment) {
            LayoutManager childLM;
            MultiSwitchLayoutManager mslm = MultiSwitchLayoutManager.this;
            LinkedList<ListElement> knuthList = new LinkedList<ListElement>();
            WhitespaceManagementPenalty penalty = new WhitespaceManagementPenalty(new WhitespaceManagementPosition(mslm));
            while ((childLM = MultiSwitchLayoutManager.this.getChildLM()) != null) {
                LayoutContext childLC = MultiSwitchLayoutManager.this.makeChildLayoutContext(context);
                LinkedList childElements = new LinkedList();
                while (!childLM.isFinished()) {
                    childElements.addAll(childLM.getNextKnuthElements(childLC, alignment));
                }
                LinkedList<ListElement> wrappedElements = new LinkedList<ListElement>();
                MultiSwitchLayoutManager.this.wrapPositionElements(childElements, wrappedElements);
                SpaceResolver.resolveElementList(wrappedElements);
                int contentLength = ElementListUtils.calcContentLength(wrappedElements);
                WhitespaceManagementPenalty whitespaceManagementPenalty = penalty;
                Objects.requireNonNull(whitespaceManagementPenalty);
                penalty.addVariant(new WhitespaceManagementPenalty.Variant(whitespaceManagementPenalty, wrappedElements, contentLength));
            }
            knuthList.add(new KnuthBox(0, new Position(mslm), false));
            knuthList.add(penalty);
            knuthList.add(new KnuthBox(0, new Position(mslm), false));
            return knuthList;
        }
    }

    private static interface KnuthElementsGenerator {
        public List<ListElement> getKnuthElements(LayoutContext var1, int var2);
    }

    private class DefaultKnuthListGenerator
    implements KnuthElementsGenerator {
        private DefaultKnuthListGenerator() {
        }

        @Override
        public List<ListElement> getKnuthElements(LayoutContext context, int alignment) {
            LinkedList<ListElement> knuthList = new LinkedList<ListElement>();
            LayoutManager childLM = MultiSwitchLayoutManager.this.getChildLM();
            while (!childLM.isFinished()) {
                LayoutContext childLC = MultiSwitchLayoutManager.this.makeChildLayoutContext(context);
                List childElements = childLM.getNextKnuthElements(childLC, alignment);
                if (childElements == null) continue;
                LinkedList newList = new LinkedList();
                MultiSwitchLayoutManager.this.wrapPositionElements(childElements, newList);
                knuthList.addAll(newList);
            }
            return knuthList;
        }
    }

    static class WhitespaceManagementPosition
    extends Position {
        private List<ListElement> knuthList;

        public WhitespaceManagementPosition(LayoutManager lm) {
            super(lm);
        }

        public List<Position> getPositionList() {
            LinkedList<Position> positions = new LinkedList<Position>();
            if (this.knuthList != null && !this.knuthList.isEmpty()) {
                SpaceResolver.performConditionalsNotification(this.knuthList, 0, this.knuthList.size() - 1, -1);
                for (ListElement el : this.knuthList) {
                    if (el.getPosition() == null) continue;
                    positions.add(el.getPosition());
                }
            }
            return positions;
        }

        public void setKnuthList(List<ListElement> knuthList) {
            this.knuthList = knuthList;
        }

        public List<ListElement> getKnuthList() {
            return this.knuthList;
        }
    }
}

