/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.stream;

import groovyx.gpars.dataflow.stream.FList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FListIterator<T>
implements Iterator<T> {
    private FList<T> current;

    public FListIterator(FList<T> list) {
        this.current = list;
    }

    @Override
    public boolean hasNext() {
        return !this.current.isEmpty();
    }

    @Override
    public T next() {
        if (this.current == null) {
            throw new NoSuchElementException("No element to return from an empty iterator");
        }
        T next = this.current.getFirst();
        this.current = this.current.getRest();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported for FList iterators");
    }
}

