/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import org.jboss.aerogear.keycloak.metrics.PrometheusExporter;
import org.jboss.logging.Logger;

public final class MetricsFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = Logger.getLogger(MetricsFilter.class);
    private static final String METRICS_REQUEST_TIMESTAMP = "metrics.requestTimestamp";
    private static final MetricsFilter INSTANCE = new MetricsFilter();
    private static final Set<MediaType> contentTypes = new HashSet<MediaType>();
    private static final Set<MediaType> CONTENT_TYPES;

    public static MetricsFilter instance() {
        return INSTANCE;
    }

    private MetricsFilter() {
    }

    public void filter(ContainerRequestContext req) {
        req.setProperty(METRICS_REQUEST_TIMESTAMP, (Object)System.currentTimeMillis());
    }

    public void filter(ContainerRequestContext req, ContainerResponseContext res) {
        int status = res.getStatus();
        if (status >= 400) {
            PrometheusExporter.instance().recordResponseError(status, req.getMethod());
        }
        if (req.getProperty(METRICS_REQUEST_TIMESTAMP) != null && this.contentTypeIsRelevant(res)) {
            long time = (Long)req.getProperty(METRICS_REQUEST_TIMESTAMP);
            long dur = System.currentTimeMillis() - time;
            LOG.trace((Object)("Duration is calculated as " + dur + " ms."));
            PrometheusExporter.instance().recordRequestDuration(dur, req.getMethod());
        }
    }

    private boolean contentTypeIsRelevant(ContainerResponseContext responseContext) {
        LOG.trace((Object)("Check if is response is relevant " + responseContext.getMediaType()));
        boolean ret = responseContext.getMediaType() != null && CONTENT_TYPES.stream().anyMatch(type -> type.isCompatible(responseContext.getMediaType()));
        LOG.trace((Object)("Result is " + ret));
        return ret;
    }

    static {
        contentTypes.add(MediaType.APPLICATION_JSON_TYPE);
        contentTypes.add(MediaType.APPLICATION_XML_TYPE);
        contentTypes.add(MediaType.TEXT_HTML_TYPE);
        CONTENT_TYPES = Collections.unmodifiableSet(contentTypes);
    }
}

