/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/stm32/h7/irq.json
 */

#ifndef LIBOPENCM3_STM32_H7_NVIC_H
#define LIBOPENCM3_STM32_H7_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for STM32 H7 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_WWDG_IRQ 0
#define NVIC_PVD_IRQ 1
#define NVIC_TAMP_STAMP_IRQ 2
#define NVIC_RTC_WKUP_IRQ 3
#define NVIC_FLASH_IRQ 4
#define NVIC_RCC_IRQ 5
#define NVIC_EXTI0_IRQ 6
#define NVIC_EXTI1_IRQ 7
#define NVIC_EXTI2_IRQ 8
#define NVIC_EXTI3_IRQ 9
#define NVIC_EXTI4_IRQ 10
#define NVIC_DMA1_STR0_IRQ 11
#define NVIC_DMA1_STR1_IRQ 12
#define NVIC_DMA1_STR2_IRQ 13
#define NVIC_DMA1_STR3_IRQ 14
#define NVIC_DMA1_STR4_IRQ 15
#define NVIC_DMA1_STR5_IRQ 16
#define NVIC_DMA1_STR6_IRQ 17
#define NVIC_ADC1_2_IRQ 18
#define NVIC_FDCAN1_IT0_IRQ 19
#define NVIC_FDCAN2_IT0_IRQ 20
#define NVIC_FDCAN1_IT1_IRQ 21
#define NVIC_FDCAN2_IT2_IRQ 22
#define NVIC_EXTI9_5_IRQ 23
#define NVIC_TIM1_BRK_TIM9_IRQ 24
#define NVIC_TIM1_UP_TIM10_IRQ 25
#define NVIC_TIM1_TRG_COM_TIM11_IRQ 26
#define NVIC_TIM1_CC_IRQ 27
#define NVIC_TIM2_IRQ 28
#define NVIC_TIM3_IRQ 29
#define NVIC_TIM4_IRQ 30
#define NVIC_I2C1_EV_IRQ 31
#define NVIC_I2C1_ER_IRQ 32
#define NVIC_I2C2_EV_IRQ 33
#define NVIC_I2C2_ER_IRQ 34
#define NVIC_SPI1_IRQ 35
#define NVIC_SPI2_IRQ 36
#define NVIC_USART1_IRQ 37
#define NVIC_USART2_IRQ 38
#define NVIC_USART3_IRQ 39
#define NVIC_EXTI15_10_IRQ 40
#define NVIC_RTC_ALARM_IRQ 41
#define NVIC_RESERVED1_IRQ 42
#define NVIC_TIM8_BRK_TIM12_IRQ 43
#define NVIC_TIM8_UP_TIM13_IRQ 44
#define NVIC_TIM8_TRG_COM_TIM14_IRQ 45
#define NVIC_TIM8_CC_IRQ 46
#define NVIC_DMA1_STR7_IRQ 47
#define NVIC_FSMC_IRQ 48
#define NVIC_SDMMC1_IRQ 49
#define NVIC_TIM5_IRQ 50
#define NVIC_SPI3_IRQ 51
#define NVIC_UART4_IRQ 52
#define NVIC_UART5_IRQ 53
#define NVIC_TIM6_DAC_IRQ 54
#define NVIC_TIM7_IRQ 55
#define NVIC_DMA2_STR0_IRQ 56
#define NVIC_DMA2_STR1_IRQ 57
#define NVIC_DMA2_STR2_IRQ 58
#define NVIC_DMA2_STR3_IRQ 59
#define NVIC_DMA2_STR4_IRQ 60
#define NVIC_ETH_IRQ 61
#define NVIC_ETH_WKUP_IRQ 62
#define NVIC_FDCAN_CAL_IRQ 63
#define NVIC_CM7_SEV_IRQ 64
#define NVIC_RESERVED2_IRQ 65
#define NVIC_RESERVED3_IRQ 66
#define NVIC_RESERVED4_IRQ 67
#define NVIC_DMA2_STR5_IRQ 68
#define NVIC_DMA2_STR6_IRQ 69
#define NVIC_DMA2_STR7_IRQ 70
#define NVIC_USART6_IRQ 71
#define NVIC_I2C3_EV_IRQ 72
#define NVIC_I2C3_ER_IRQ 73
#define NVIC_OTG_HS_EP1_OUT_IRQ 74
#define NVIC_OTG_HS_EP1_IN_IRQ 75
#define NVIC_OTG_HS_WKUP_IRQ 76
#define NVIC_OTG_HS_IRQ 77
#define NVIC_DCMI_IRQ 78
#define NVIC_CRYP_IRQ 79
#define NVIC_HASH_RNG_IRQ 80
#define NVIC_FPU_IRQ 81
#define NVIC_UART7_IRQ 82
#define NVIC_UART8_IRQ 83
#define NVIC_SPI4_IRQ 84
#define NVIC_SPI5_IRQ 85
#define NVIC_SPI6_IRQ 86
#define NVIC_SAI1_IRQ 87
#define NVIC_LTDC_IRQ 88
#define NVIC_LTDC_ER_IRQ 89
#define NVIC_DMA2D_IRQ 90
#define NVIC_SAI2_IRQ 91
#define NVIC_QUADSPI_IRQ 92
#define NVIC_LP_TIM1_IRQ 93
#define NVIC_CEC_IRQ 94
#define NVIC_I2C4_EV_IRQ 95
#define NVIC_I2C4_ER_IRQ 96
#define NVIC_SPDIFRX_IRQ 97
#define NVIC_OTG_FS_EP1_OUT_IRQ 98
#define NVIC_OTG_FS_EP1_IN_IRQ 99
#define NVIC_OTG_FS_WKUP_IRQ 100
#define NVIC_OTG_FS_IRQ 101
#define NVIC_DMAMUX1_OV_IRQ 102
#define NVIC_HRTIM1_MST_IRQ 103
#define NVIC_HRTIM1_TIMA_IRQ 104
#define NVIC_HRTIM1_TIMB_IRQ 105
#define NVIC_HRTIM1_TIMC_IRQ 106
#define NVIC_HRTIM1_TIMD_IRQ 107
#define NVIC_HRTIM1_TIME_IRQ 108
#define NVIC_HRTIM1_FLT_IRQ 109
#define NVIC_DFSDM1_IT0_IRQ 110
#define NVIC_DFSDM1_IT1_IRQ 111
#define NVIC_DFSDM1_IT2_IRQ 112
#define NVIC_DFSDM1_IT3_IRQ 113
#define NVIC_SAI3_IRQ 114
#define NVIC_SWPMI1_IRQ 115
#define NVIC_TIM15_IRQ 116
#define NVIC_TIM16_IRQ 117
#define NVIC_TIM17_IRQ 118
#define NVIC_MDIOS_WKUP_IRQ 119
#define NVIC_MDIOS_IRQ 120
#define NVIC_JPEG_IRQ 121
#define NVIC_MDMA_IRQ 122
#define NVIC_RESERVED5_IRQ 123
#define NVIC_SDMMC2_IRQ 124
#define NVIC_HSEM0_IRQ 125
#define NVIC_RESERVED6_IRQ 126
#define NVIC_ADC3_IRQ 127
#define NVIC_DMAMUX2_OVR_IRQ 128
#define NVIC_BDMA_CH0_IRQ 129
#define NVIC_BDMA_CH1_IRQ 130
#define NVIC_BDMA_CH2_IRQ 131
#define NVIC_BDMA_CH3_IRQ 132
#define NVIC_BDMA_CH4_IRQ 133
#define NVIC_BDMA_CH5_IRQ 134
#define NVIC_BDMA_CH6_IRQ 135
#define NVIC_BDMA_CH7_IRQ 136
#define NVIC_COMP_IRQ 137
#define NVIC_LPTIM2_IRQ 138
#define NVIC_LPTIM3_IRQ 139
#define NVIC_LPTIM4_IRQ 140
#define NVIC_LPTIM5_IRQ 141
#define NVIC_LPUART_IRQ 142
#define NVIC_WWDG1_RST_IRQ 143
#define NVIC_CRS_IRQ 144
#define NVIC_RAMECC1_IRQ 145
#define NVIC_SAI4_IRQ 146
#define NVIC_RESERVED7_IRQ 147
#define NVIC_RESERVED8_IRQ 148
#define NVIC_WKUP_IRQ 149

#define NVIC_IRQ_COUNT 150

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_STM32H7 User interrupt service routines (ISR) prototypes for STM32 H7 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void wwdg_isr(void);
void pvd_isr(void);
void tamp_stamp_isr(void);
void rtc_wkup_isr(void);
void flash_isr(void);
void rcc_isr(void);
void exti0_isr(void);
void exti1_isr(void);
void exti2_isr(void);
void exti3_isr(void);
void exti4_isr(void);
void dma1_str0_isr(void);
void dma1_str1_isr(void);
void dma1_str2_isr(void);
void dma1_str3_isr(void);
void dma1_str4_isr(void);
void dma1_str5_isr(void);
void dma1_str6_isr(void);
void adc1_2_isr(void);
void fdcan1_it0_isr(void);
void fdcan2_it0_isr(void);
void fdcan1_it1_isr(void);
void fdcan2_it2_isr(void);
void exti9_5_isr(void);
void tim1_brk_tim9_isr(void);
void tim1_up_tim10_isr(void);
void tim1_trg_com_tim11_isr(void);
void tim1_cc_isr(void);
void tim2_isr(void);
void tim3_isr(void);
void tim4_isr(void);
void i2c1_ev_isr(void);
void i2c1_er_isr(void);
void i2c2_ev_isr(void);
void i2c2_er_isr(void);
void spi1_isr(void);
void spi2_isr(void);
void usart1_isr(void);
void usart2_isr(void);
void usart3_isr(void);
void exti15_10_isr(void);
void rtc_alarm_isr(void);
void reserved1_isr(void);
void tim8_brk_tim12_isr(void);
void tim8_up_tim13_isr(void);
void tim8_trg_com_tim14_isr(void);
void tim8_cc_isr(void);
void dma1_str7_isr(void);
void fsmc_isr(void);
void sdmmc1_isr(void);
void tim5_isr(void);
void spi3_isr(void);
void uart4_isr(void);
void uart5_isr(void);
void tim6_dac_isr(void);
void tim7_isr(void);
void dma2_str0_isr(void);
void dma2_str1_isr(void);
void dma2_str2_isr(void);
void dma2_str3_isr(void);
void dma2_str4_isr(void);
void eth_isr(void);
void eth_wkup_isr(void);
void fdcan_cal_isr(void);
void cm7_sev_isr(void);
void reserved2_isr(void);
void reserved3_isr(void);
void reserved4_isr(void);
void dma2_str5_isr(void);
void dma2_str6_isr(void);
void dma2_str7_isr(void);
void usart6_isr(void);
void i2c3_ev_isr(void);
void i2c3_er_isr(void);
void otg_hs_ep1_out_isr(void);
void otg_hs_ep1_in_isr(void);
void otg_hs_wkup_isr(void);
void otg_hs_isr(void);
void dcmi_isr(void);
void cryp_isr(void);
void hash_rng_isr(void);
void fpu_isr(void);
void uart7_isr(void);
void uart8_isr(void);
void spi4_isr(void);
void spi5_isr(void);
void spi6_isr(void);
void sai1_isr(void);
void ltdc_isr(void);
void ltdc_er_isr(void);
void dma2d_isr(void);
void sai2_isr(void);
void quadspi_isr(void);
void lp_tim1_isr(void);
void cec_isr(void);
void i2c4_ev_isr(void);
void i2c4_er_isr(void);
void spdifrx_isr(void);
void otg_fs_ep1_out_isr(void);
void otg_fs_ep1_in_isr(void);
void otg_fs_wkup_isr(void);
void otg_fs_isr(void);
void dmamux1_ov_isr(void);
void hrtim1_mst_isr(void);
void hrtim1_tima_isr(void);
void hrtim1_timb_isr(void);
void hrtim1_timc_isr(void);
void hrtim1_timd_isr(void);
void hrtim1_time_isr(void);
void hrtim1_flt_isr(void);
void dfsdm1_it0_isr(void);
void dfsdm1_it1_isr(void);
void dfsdm1_it2_isr(void);
void dfsdm1_it3_isr(void);
void sai3_isr(void);
void swpmi1_isr(void);
void tim15_isr(void);
void tim16_isr(void);
void tim17_isr(void);
void mdios_wkup_isr(void);
void mdios_isr(void);
void jpeg_isr(void);
void mdma_isr(void);
void reserved5_isr(void);
void sdmmc2_isr(void);
void hsem0_isr(void);
void reserved6_isr(void);
void adc3_isr(void);
void dmamux2_ovr_isr(void);
void bdma_ch0_isr(void);
void bdma_ch1_isr(void);
void bdma_ch2_isr(void);
void bdma_ch3_isr(void);
void bdma_ch4_isr(void);
void bdma_ch5_isr(void);
void bdma_ch6_isr(void);
void bdma_ch7_isr(void);
void comp_isr(void);
void lptim2_isr(void);
void lptim3_isr(void);
void lptim4_isr(void);
void lptim5_isr(void);
void lpuart_isr(void);
void wwdg1_rst_isr(void);
void crs_isr(void);
void ramecc1_isr(void);
void sai4_isr(void);
void reserved7_isr(void);
void reserved8_isr(void);
void wkup_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_STM32_H7_NVIC_H */
